tic;
clear;
pvar x1 x2 x3 J;

%%% System paramters %%%
load parameters_disc_3D.mat;
load noise_parameters.mat;
x=[x1;x2;x3];
Z=diag([2 7 1]);
n=length(x);
A=Epsilon_disc.a;
B=Epsilon_disc.b;
C=Epsilon_disc.c;
X=P_epsilon;
W=Q_epsilon;
V=R_epsilon;
L=L_epsilon;
lambda=.1;
Q=(eye(n)-L*C)*X;
Y=L*(C*A*Q*A'*C'+C*W*C'+V)*L';
save test_data.mat A B C X W V L Y Q lambda;

%%% Input the highest degree here %%%
high_degree=6;

%%% Input phi and d in algorithm 6.3 here %%%
phi=2;
d=lambda*0.5;

%%% Calculate the expected value function of the monomials in the
%%% polynomial
s(1,:)=ones(1,high_degree);
for j=1:high_degree
    s(2,j)=j+1;
    if n>3
        error('Have not figured out the rule for producing monomials with higher than 3 order');
    else if n==3
        s(3,j)=(j+1)*(j+2)/2;
        end
    end
end
 
load moment_data.mat;%[moment cm]=one_step_expect_monomials(high_degree,x,A,Y);%
toc
%save moment_data.mat moment cm;

%%% SOS algorithm starts here %%%
% initialization
prog=sosprogram(x);
% define variable
prog=sosdecvar(prog,J);

[prog,f]=sospolyvar(prog,monomials(x,2:2:high_degree),'wscoeff');
% define inequalities
term_num=length(f.coefficient);
E_f=0;
E_f_0=0;
for i=1:term_num
    coefficient_tend=polynomial(1,[f.degmat(i,1:term_num) zeros(1,n)],f.varname,[1 1]);
    pos_tend=position(f.degmat(i,term_num+1:term_num+n),s);
    row_tend=ceil(pos_tend/57);
    E_f=E_f+coefficient_tend*moment(row_tend,pos_tend-57*(row_tend-1));
    E_f_0=E_f_0+coefficient_tend*cm(pos_tend);
end
% constraints
step_inv=(x'*Z*x/d)^phi+1;
cs1=step_inv*(J+f-(E_f+x'*Z*x))-(E_f+x'*Z*x)*(step_inv-1)*(d-x'*Z*x);
cs2=step_inv*(J+f-(E_f_0+lambda))+(E_f_0+lambda)*(d-x'*Z*x);
prog=sosineq(prog,cs1);
prog=sosineq(prog,cs2);
% The following two inequalities are not necessary, but these two
% inequalities helps SeDuMi find feasible solutions.
prog=sosineq(prog,f);
prog=sosineq(prog,J);
% define objective
prog=sossetobj(prog,J);
% call solver
[prog,info]=sossolve(prog);
% get solution
Js=sosgetsol(prog,J)+trace(Q*Z)
fs=sosgetsol(prog,f);
Ef0=0;
Ef=0;
for i=1:term_num
    coefficient_tend=polynomial(1,[f.degmat(i,1:term_num) zeros(1,n)],f.varname,[1 1]);
    c_t=sosgetsol(prog,coefficient_tend);
    pos_tend=position(f.degmat(i,term_num+1:term_num+n),s);
    row_tend=ceil(pos_tend/57);
    Ef=Ef+c_t*moment(row_tend,pos_tend-57*(row_tend-1));
    Ef0=Ef0+c_t*cm(pos_tend);
end
poly_event_trigger=Ef-Ef0+x'*Z*x-lambda
% save eve_dec.mat Ef0 Ef Js lambda;
% load ../closed_loop_parameters.mat;
% load ../parameters.mat;
% load ../input.mat;
% pause;
% % check feasibility
% cs11=step_inv*(Js+fs-(Ef+x'*x))-(Ef+x'*x)*(step_inv-1)*(c-x'*x);
% cs22=step_inv*(Js+fs-(Ef0+lambda))+(Ef0+lambda)*(c-x'*x);
% [Q1 Z1]=findsos(cs11)
% [Q2 Z2]=findsos(cs11)
% dots=-5:5;
% j=0;
% for i=dots
%     j=j+1;
%     vl(j)=double(Js);
%     for k=1:length(fs.coefficient)
%         vl(j)=vl(j)+fs.coefficient(k)*i^(fs.degmat(k));
%     end
%     vr1=i*i;
%     for k=1:length(Ef.coefficient)
%         vr1=vr1+Ef.coefficient(k)*i^(Ef.degmat(k));
%     end
%     vr(j)=min(vr1,double(Ef0)+lambda);
% end